<script>
	$(document).ready(function()
	{
		var dropZone = $('#drop_zone'),
			maxFileSize = 20000000;
			drop_file = true;

		if(drop_file && typeof(window.FileReader) != 'undefined') 
		{
			dropZone[0].ondragover = function(event)
			{
				dropZone.addClass('hover');

				return false;
			};

			dropZone[0].ondragleave = function()
			{
				dropZone.removeClass('hover');

				return false;
			};

			dropZone[0].ondrop = function(event)
			{
				event.preventDefault();
				dropZone.removeClass('hover');

				var file = event.dataTransfer.files[0];

				if (file.size > maxFileSize)
				{
					show_noty('Down', 'error', '<a>Файл слишком большой</a>', '3000');

					dropZone.addClass('error');

					setTimeout(function(){dropZone.removeClass('error')}, 1000);

					return false;
				}

				var data = new FormData;

				data.append('file', file);
				data.append('token', $('#token').val());
				data.append('drop_img', '1');
				data.append('phpaction', '1');

				clearInterval(chat_interval);

				NProgress.start();

				$.ajax({
					type: 'post',
					url: '../ajax/chat_actions.php',
					data: data,
					processData: false,
					contentType: false,
					dataType: 'json',
					success: function(result)
					{
						NProgress.done();

						chat_get_messages(1);

						if(result.status == 1)
							setTimeout(show_ok, 500);
						else{
							setTimeout(show_error, 500);

							show_noty('Down', 'error', '<a>'+result.data+'</a>', '3000');

							dropZone.addClass('error');

							setTimeout(function(){dropZone.removeClass('error')}, 1000);
						}
					}
				});
			};
		}

		get_smiles('#chatmsgsmile');

		chatmsg_list_last();

		$('#chatmsgtext').keydown(function(event)
		{
			if(event.which == 13 && !event.shiftKey)
			{
				if($('#stop_sending').val() == 0)
				{
					event.preventDefault();

					chatmsg_send();
				}else
					return false;
			}
		});
	});

	$('#chatmsgsmile').popover({html: true, animation: true, trigger: 'click'});
	$('#chatmsgsmile').on('show.bs.popover', function()
	{
		$(document).mouseup(function(e)
		{
			var container = $('.popover-content');

			if(container.has(e.target).length === 0)
			{
				$('#chatmsgsmile').popover('hide');

				selected = 'gcms_smiles';
			}
		});
	});

	function set_sticker(elem)
	{
		if($('#stop_sending').val() == 0)
		{
			chatmsg_send(encodeURIComponent('sticker'+$(elem).attr('src')));

			$('#chatmsgsmile').popover('hide');

			selected = 'gcms_smiles';
		}
	}

	function set_smile(elem)
	{
		$('#chatmsgtext').focus();

		var text = $('#chatmsgtext').val() == 'Написать сообщение...' ? '' : $('#chatmsgtext').val();
		var smile = $(elem).attr('title');

		$('#chatmsgtext').val(text+' '+smile+' ');

		selected = 'gcms_smiles';
	}

	var block = document.getElementById('chatmsgs');
	var load_val = $('#load_val').val();

	block.onscroll = function()
	{
		if((block.scrollTop < 300) && (load_val == $('#load_val').val()))
		{
			$('#load_val').val(+load_val + 1);

			chatmsg_list_top();
		}
	}
</script>